﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WzoryDokumentowDoPobrania.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.WzoryDokumentowDoPobrania" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Wzory dokumentów do pobrania</title>
    <link rel="stylesheet" type="text/css" href="../PlikiDoPobrania.css?1" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />

    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/jquery.bgiframe-2.1.2.js" type="text/javascript"></script>
    <script type="text/javascript" src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js"></script>


    <script type="text/javascript">

        function showDodajGrupeDialog() {
            $("#<%=tbNazwaGrupy.ClientID%>").val("");
            $("#dialog-form-dodaj-grupe").parent().appendTo(jQuery("form:first"));
            $("#dialog-form-dodaj-grupe").dialog("open");
        }

        function showDodajPlikDialog(idGrupy) {
            $("#<%=tbPlikDodajIdGrupy.ClientID%>").val(idGrupy);
            $("#<%=tbPlikNazwaDoWyswietlenia.ClientID%>").val("");
            $("#dialog-form-dodaj-plik").parent().appendTo(jQuery("form:first"));
            $("#dialog-form-dodaj-plik").dialog("open");
        }

        function showZmienPlikDialog(idPliku, nazwaPliku, nazwaWyswietl) {
            $("#<%=tbPlikZmienIdPliku.ClientID%>").val(idPliku);
            $("#<%=lblPlikZmienNazwaPliku.ClientID%>").text(nazwaPliku);
            $("#<%=tbPlikZmienNazwaDoWyswietlenia.ClientID%>").val(nazwaWyswietl);
            $("#dialog-form-zmien-plik").parent().appendTo(jQuery("form:first"));
            $("#dialog-form-zmien-plik").dialog("open");
        }
    </script>

    <script type="text/javascript">
        $(function () {

            $("#dialog-form-dodaj-grupe").dialog({
                autoOpen: false,
                height: 170,
                width: 400,
                modal: true,
                position: "top",

                close: function () {
                    allFields.val("").removeClass("ui-state-error");
                }
            });

            $("#dialog-form-dodaj-plik").dialog({
                autoOpen: false,
                height: 180,
                width: 400,
                modal: true,
                position: "top",

                close: function () {
                    allFields.val("").removeClass("ui-state-error");
                }
            });

            $("#dialog-form-zmien-plik").dialog({
                autoOpen: false,
                height: 220,
                width: 400,
                modal: true,
                position: "top",

                close: function () {
                    allFields.val("").removeClass("ui-state-error");
                }
            });

            $('#fuPlik').bind('change', function () {
                //fileUpload = 0;
                var iSize = (this.files[0].size / 1024);
                if (iSize / 1024 > 1) {
                    if (((iSize / 1024) / 1024) > 1) {
                        fileUpload = 0;
                    } else {
                        iSize = (Math.round((iSize / 1024) * 100) / 100);
                        if (iSize <= 3) {
                            fileUpload = 1;
                        } else {
                            fileUpload = 0;
                        }
                    }
                } else {
                    fileUpload = 1;
                }
                if (fileUpload == 0) {
                    alert("Wielkość pliku nie może przekraczać 3MB.");
                    //jQuery('#attached').html('Your attachment exceeded 3MB.');
                    $('#fuPlik').val('');
                }

            });



            $("#btnDodajGrupe").button({ icons: { primary: 'ui-icon-plusthick' } });
            $("#btnGrupaZapisz").button();
            $("#btnGrupaAnuluj").button();
            $(".btnUsunGrupeClass").button({ icons: { primary: 'ui-icon-trash' } });
            $(".btnDodajPlikClass").button({ icons: { primary: 'ui-icon-plusthick' } });
            $(".btnUsunPlikClass").button({ icons: { primary: 'ui-icon-trash' } });
            $(".btnZmienPlikClass").button({ icons: { primary: 'ui-icon-pencil' } });
            $(".btnGrupaUpClass").button({ icons: { primary: 'ui-icon-arrowthick-1-n' } });
            $(".btnGrupaUpDisabledClass").button({ icons: { primary: 'ui-icon-arrowthick-1-n' } }).attr("disabled", true).addClass("ui-state-disabled");
            $(".btnGrupaDownClass").button({ icons: { primary: 'ui-icon-arrowthick-1-s' } });
            $(".btnGrupaDownDisabledClass").button({ icons: { primary: 'ui-icon-arrowthick-1-s' } }).attr("disabled", true).addClass("ui-state-disabled");
            $(".btnPlikUpClass").button({ icons: { primary: 'ui-icon-arrowthick-1-n' } });
            $(".btnPlikUpDisabledClass").button({ icons: { primary: 'ui-icon-arrowthick-1-n' } }).attr("disabled", true).addClass("ui-state-disabled");
            $(".btnPlikDownClass").button({ icons: { primary: 'ui-icon-arrowthick-1-s' } });
            $(".btnPlikDownDisabledClass").button({ icons: { primary: 'ui-icon-arrowthick-1-s' } }).attr("disabled", true).addClass("ui-state-disabled");


        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label>
        </div>
        <div>
            <button id="btnDodajGrupe" runat="server" type="button" value="Do Akceptacji"
                onclick="showDodajGrupeDialog();" style="display: none; font-weight: normal; color: Black;">
                Dodaj grupę</button>
        </div>
        <div id="divWzoryDokPodmenu" runat="server">
        </div>
        <!-- Okienko dialogu dodaj grupę -->
        <div id="dialog-form-dodaj-grupe" title="Dodaj grupę">
            <div style="width: 100%; height: 70%;">
                <span id="lblNazwaGrupy">Nazwa grupy </span>
                <asp:TextBox ID="tbNazwaGrupy" runat="server" TextMode="SingleLine" Style="width: 70%;"
                    class="text ui-widget-content ui-corner-all"></asp:TextBox>
                <br />
                <br />
                <span id="lblGrupaNadrzedna">Grupa nadrzędna </span>
                <asp:DropDownList ID="ddlGrupaNadrzedna" runat="server" Style="width: 70%;">
                </asp:DropDownList>
            </div>
            <div style="height: 5px;">
                &nbsp;
            </div>
            <div>
                <div style="float: right;">
                    <asp:Button ID="btnGrupaZapisz" runat="server" Text="Zapisz" OnClick="btnGrupaZapisz_Click" />
                    <asp:Button ID="btnGrupaAnuluj" runat="server" Text="Anuluj" OnClick="btnGrupaAnuluj_Click" />
                </div>
            </div>
        </div>
        <!-- Okienko dialogu dodaj plik -->
        <div id="dialog-form-dodaj-plik" title="Dodaj dokument">
            <div style="width: 100%; height: 70%;">
                <span id="lblPlikNazwaDoWyswietlenia">Nazwa do wyświetlenia </span><br />
                <asp:TextBox ID="tbPlikNazwaDoWyswietlenia" runat="server" TextMode="SingleLine" Style="width: 90%;"
                    class="text ui-widget-content ui-corner-all"></asp:TextBox>
                <br />
                <br />
                <span id="lblPlik">Plik </span><br />
                <asp:FileUpload ID="fuPlik" runat="server" Style="width: 90%;"
                    class="text ui-widget-content ui-corner-all" />
                <br />
                <br />
                <span >Maksymalna wielkość pliku 3 MB </span><br />
            </div>
            <div style="height: 5px;">
                &nbsp;<asp:TextBox ID="tbPlikDodajIdGrupy" runat="server" TextMode="SingleLine" Style="width: 1px; display: none;"></asp:TextBox>
            </div>
            <div>
                <div style="float: right;">
                    <asp:Button ID="btnPlikZapisz" runat="server" Text="Zapisz" OnClick="btnPlikZapisz_Click" />
                    <asp:Button ID="btnPlikAnuluj" runat="server" Text="Anuluj" OnClick="btnPlikAnuluj_Click" />
                </div>
            </div>
        </div>
        <!-- Okienko dialogu zmien plik -->
        <div id="dialog-form-zmien-plik" title="Zmień dokument">
            <div style="width: 100%; height: 150px;">
                <span id="lblPlikZmienNazwaDoWyswietlenia">Nazwa do wyświetlenia </span><br />
                <asp:TextBox ID="tbPlikZmienNazwaDoWyswietlenia" runat="server" TextMode="SingleLine" Style="width: 90%;"
                    class="text ui-widget-content ui-corner-all"></asp:TextBox>
                <br />
                <br />
                <span id="lblPlikZmien">Plik </span><br />
                <asp:FileUpload ID="fuPlikZmien" runat="server" Style="width: 90%;"
                    class="text ui-widget-content ui-corner-all" />
                <br />
                <br />
                <span >Maksymalna wielkość pliku 3 MB </span><br />
                <span >Nowy plik powinien mieć inną nazwę, brak zmiany nazwy pliku może spowodować, że przeglądarka będzie pokazywała stary wcześniej ściągnięty plik. </span><br />
                <asp:Label id="lblPlikZmienNazwaPliku" Style="font-weight:bold;" runat="server">a</asp:Label>
            </div>
            <div style="height: 5px;">
                &nbsp;<asp:TextBox ID="tbPlikZmienIdPliku" runat="server" TextMode="SingleLine" Style="width: 1px; display: none;"></asp:TextBox>
            </div>
            <div>
                <div style="float: right;">
                    <asp:Button ID="btnPlikZmienZapisz" runat="server" Text="Zapisz" OnClick="btnPlikZmienZapisz_Click" />
                    <asp:Button ID="btnPlikZmienAnuluj" runat="server" Text="Anuluj" OnClick="btnPlikZmienAnuluj_Click" />
                </div>
            </div>
        </div>
    </form>
</body>
</html>
